//
//  NSString+MCAdditions.h
//  MCFoundation
//
//  Created by Thomas Bartelmess on 10-03-28.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface NSString (MCAdditions) 
- (NSString *)capitalizedStringWithPerservedCamelCase;
+ (NSString *)stringWithUnichar:(unichar)unicharValue;

// These currently only support IP4
- (BOOL)isValidIPAddress:(NSString **)err;
- (BOOL)isValidDomainNamePedantic:(BOOL)requiresDot errorString:(NSString **)err;
// calls each of the above, requiresDot = NO
- (BOOL)isValidNetworkAddress:(NSString **)err;
// either a *.local or 169.x.x.x
- (BOOL)isValidLinkLocalAddress:(NSString **)err;
// not link local and not in the 10.x.x.x, 192.168.x.x or 172.x.x.x blocks
- (BOOL)isValidInternetIPAddress:(NSString **)err; // if it's an IP address but not an Internet address it's in a private block

@end
